// This code, in its entirety, is Copyrighted Terry Smith, 2000.

import java.io.*;
import java.sql.*;
import java.math.BigDecimal;

import Utilities;

public class EasyResultSet
{
   private ResultSet m_ResultSet;
   private int m_ColumnIndex = 1;

   public EasyResultSet( PreparedStatement Statement ) throws java.sql.SQLException
   {
      m_ResultSet = Statement.executeQuery();
   }

   public boolean next() throws java.sql.SQLException
   {
      m_ColumnIndex = 1;
      return m_ResultSet.next();
   }

   public void close() throws java.sql.SQLException
   {
      if (m_ResultSet != null)
      {
         m_ResultSet.close();
      }
   }

   /**
   * readString uses ResultSet.getObject which returns null on NULL columns
   * instead of ResultSet.getString which would return "null".
   *
   * @return Value read after being trimmed.
   */
   public String readString() throws java.sql.SQLException
   {
      String ColumnValue = (String)m_ResultSet.getObject( m_ColumnIndex );
      m_ColumnIndex++;

      if ( ColumnValue != null )
      {
         ColumnValue = ColumnValue.trim();
      }

      return ColumnValue;
   }

   /**
   * readInteger assumes that you are storing integer types in the database using the
   * the NUMBER data type. This routine does not rely on the JDBC 2.0 feature
   * of using ResultSet.getBigDecimal to read NUMBER data types. Instead, it uses
   * ResultSet.getObject.
   *
   * @return Value read converted to an Integer for non-null values. Returns null
   *         on null columns.
   */
   public Integer readInteger() throws java.sql.SQLException
   {
      BigDecimal ColumnValue = (BigDecimal)m_ResultSet.getObject( m_ColumnIndex );
      m_ColumnIndex++;

      if ( ColumnValue == null )
      {
         return null;
      }
      else
      {
         return new Integer( ColumnValue.intValue() );
      }
   }

   /**
   * readLong assumes that you are storing long types in the database using the
   * the NUMBER data type. This routine does not rely on the JDBC 2.0 feature
   * of using ResultSet.getBigDecimal to read NUMBER data types. Instead, it uses
   * ResultSet.getObject.
   *
   * @return Value read converted to an Integer for non-null values. Returns null
   *         on null columns.
   */
   public Long readLong() throws java.sql.SQLException
   {
      BigDecimal ColumnValue = (BigDecimal)m_ResultSet.getObject( m_ColumnIndex );
      m_ColumnIndex++;

      if ( ColumnValue == null )
      {
         return null;
      }
      else
      {
         return new Long( ColumnValue.longValue() );
      }
   }

   /**
   * readDate assumes that you are storing date types using Oracle's DATE date
   * type or something compatible. It uses ResultSet.getTimestamp to read the
   * date and the time (as opposed to getDate and getTime) and then converts
   * the value read into a java.util.Date.
   */
   public java.util.Date readDate() throws java.sql.SQLException
   {
      Timestamp TempColumnValue = m_ResultSet.getTimestamp( m_ColumnIndex );
      m_ColumnIndex++;

      if ( TempColumnValue == null )
      {
         return null;
      }
      else
      {
         return new java.util.Date( TempColumnValue.getTime() );
      }
   }

   /**
   * readBoolean assumes that you are storing boolean types in the database using
   * a CHAR(1).
   *
   * @return After uppercasing the value read, it will return true if the value
   * is either "T" or "TRUE". It returns false in all other instance including
   * a NULL value.
   */
   public boolean readBoolean() throws java.sql.SQLException
   {
      String ColumnValue = m_ResultSet.getString( m_ColumnIndex );
      m_ColumnIndex++;

      return Utilities.stringToBoolean( ColumnValue );
   }
}
